{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitCanviDeParametres;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TFormCanviDeParametres = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    EditMaxim: TEdit;
    EditMinim: TEdit;
    EditIncrementX: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    BitBtnMicrofon: TBitBtn;
    procedure EditMaximExit(Sender: TObject);
    procedure EditMinimExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditIncrementXExit(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BitBtnMicrofonClick(Sender: TObject);
    procedure BitBtnCancelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    PucTancar:boolean;
  public
    { Public declarations }
    P1,P2,P3:string;
  end;

var
  FormCanviDeParametres: TFormCanviDeParametres;
  ValorMaxim,ValorMinim,IncrementX:integer;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo;

{$R *.DFM}

procedure TFormCanviDeParametres.FormCreate(Sender: TObject);
begin
  ValorMaxim:=128;
  ValorMinim:=20;
  IncrementX:=2;
end;

procedure TFormCanviDeParametres.EditMaximExit(Sender: TObject);
var
  VMa,VMi:integer;
begin
  VMa:=StrToInt(EditMaxim.Text);
  VMi:=StrToInt(EditMinim.Text);
  PucTancar:=true;
  if VMA>128 then begin
    MessageBox(Handle,PChar(MessageString2),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditMaxim.Text:='128';
    EditMaxim.SetFocus;
    PucTancar:=false;
  end else if VMA<=VMi then begin
    MessageBox(Handle,PChar(MessageString3+EditMinim.Text),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditMaxim.Text:='128';
    EditMaxim.SetFocus;
    PucTancar:=false;
  end;
  ValorMaxim:=StrToInt(EditMaxim.Text);
end;

procedure TFormCanviDeParametres.EditMinimExit(Sender: TObject);
var
  VMa,VMi:integer;
begin
  VMa:=StrToInt(EditMaxim.Text);
  VMi:=StrToInt(EditMinim.Text);
  PucTancar:=true;
  if VMi<0 then begin
    MessageBox(Handle,PChar(MessageString4),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditMinim.Text:='20';
    EditMinim.SetFocus;
    PucTancar:=false;
  end else if VMA<=VMi then begin
    MessageBox(Handle,PChar(MessageString5+EditMaxim.Text),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditMinim.Text:='0';
    EditMinim.SetFocus;
    PucTancar:=false;
  end;
  ValorMinim:=StrToInt(EditMinim.Text);
end;

procedure TFormCanviDeParametres.EditIncrementXExit(Sender: TObject);
var
  IX:integer;
begin
  IX:=StrToInt(EditIncrementX.Text);
    PucTancar:=true;
  if IX<1 then begin
    MessageBox(Handle,PChar(MessageString6),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditIncrementX.Text:='2';
    PucTancar:=false;
  end else if IX>16 then begin
    MessageBox(Handle,PChar(MessageString7),'Globus 2', mb_Ok or MB_ICONSTOP);
    EditIncrementX.Text:='16';
    PucTancar:=false;
  end;
  IncrementX:=StrToInt(EditIncrementX.Text);
end;

procedure TFormCanviDeParametres.FormCloseQuery(Sender: TObject;var CanClose: Boolean);
begin
  EditMaximExit(Sender);
  if not PucTancar then begin
    CanClose:=false;
    exit;
  end;
  EditMinimExit(Sender);
  if not PucTancar then begin
    CanClose:=false;
    exit;
  end;
  EditIncrementXExit(Sender);
  if not PucTancar then begin
    CanClose:=false;
    exit;
  end;
  writePrivateProfileString('Parametres','Maxim',PChar(EditMaxim.Text),'globus3.ini');
  writePrivateProfileString('Parametres','Minim',PChar(EditMinim.Text),'globus3.ini');
  writePrivateProfileString('Parametres','Increment X',PChar(EditIncrementX.Text),'globus3.ini');
end;

procedure TFormCanviDeParametres.BitBtnMicrofonClick(Sender: TObject);
var
  h:THandle;
begin
  h:=FindWindow(nil,'Volume Control');
  if h=0 then begin
    WinExec('sndvol32.exe',SW_SHOWNORMAL);
  end else begin
    if IsIconic(h) then ShowWindow(h,SW_SHOWNORMAL);
    BringWindowToTop(h);
  end;
end;

procedure TFormCanviDeParametres.BitBtnCancelClick(Sender: TObject);
begin
  EditMaxim.Text:=P1;
  EditMinim.Text:=P2;
  EditIncrementX.Text:=P3;
end;

procedure TFormCanviDeParametres.FormActivate(Sender: TObject);
begin
  P1:=EditMaxim.Text;
  P2:=EditMinim.Text;
  P3:=EditIncrementX.Text;
end;

end.
